# gui/activation_window.py (完整修正版)

import sys
import threading
import os
from datetime import datetime
from PyQt6.QtWidgets import QDialog, QVBoxLayout, QFormLayout, QLineEdit, QLabel, QPushButton, QMessageBox
from PyQt6.QtCore import Qt, pyqtSignal

from licensing.licensing_module import activate_online, save_license


class ActivationWindow(QDialog):
    # 【修改】让信号可以传递布尔值和字符串
    activation_completed = pyqtSignal(bool, object)

    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("软件激活")
        self.setFixedSize(400, 250)
        main_layout = QVBoxLayout(self)
        form_layout = QFormLayout()
        self.user_entry = QLineEdit(self)
        self.user_entry.setPlaceholderText("仅在首次激活时设置，后续无法更改")
        form_layout.addRow("请输入您的用户名:", self.user_entry)
        self.code_entry = QLineEdit(self)
        self.code_entry.setPlaceholderText("请输入您的激活码")
        form_layout.addRow("请输入您的激活码:", self.code_entry)
        main_layout.addLayout(form_layout)
        info_label = QLabel("请勿重复激活\n如已激活过出现该提示，请检查您的网络。", self)
        info_label.setStyleSheet("color: grey;")
        info_label.setAlignment(Qt.AlignmentFlag.AlignCenter)
        main_layout.addWidget(info_label)
        self.status_label = QLabel("", self)
        self.status_label.setAlignment(Qt.AlignmentFlag.AlignCenter)
        main_layout.addWidget(self.status_label)
        activate_button = QPushButton("激活", self)
        activate_button.clicked.connect(self.activate_app)
        main_layout.addWidget(activate_button)
        self.activation_completed.connect(self.handle_activation_result)

    def activate_app(self):
        activation_code = self.code_entry.text().strip()
        username = self.user_entry.text().strip()
        if not activation_code or not username:
            QMessageBox.warning(self, "输入错误", "用户名和激活码均不能为空。")
            return
        self.status_label.setText("正在激活，请稍候...")
        machine_code = self.parent().machine_code
        thread = threading.Thread(
            target=self.run_activation_in_thread,
            args=(machine_code, activation_code, username),
            daemon=True
        )
        thread.start()

    def run_activation_in_thread(self, machine_code, activation_code, username):
        # 【修改】接收 (success, data_or_message) 元组
        success, data_or_message = activate_online(machine_code, activation_code, username)

        if success:
            # 【关键修复】在这里也传入 app_name，确保保存到正确的文件夹
            save_success = save_license(activation_code, app_name="alphabot_personal_multi")
            if save_success:
                self.activation_completed.emit(True, data_or_message)
            else:
                self.activation_completed.emit(False, "激活成功，但保存许可证到本地失败！请检查程序权限。")
        else:
            # 失败时，将服务器返回的错误消息发送出去
            self.activation_completed.emit(False, data_or_message)

    def handle_activation_result(self, success, data_or_message):
        if success:
            QMessageBox.information(self, "成功", "激活成功！")
            self.accept()
        else:
            self.status_label.setText("激活失败，请检查信息或联系管理员。")
            # 【修改】显示从服务器接收到的具体错误消息
            QMessageBox.critical(self, "激活失败", str(data_or_message))