# main.py

import sys
import logging
from PyQt6.QtWidgets import QApplication, QMessageBox
from PyQt6.QtCore import QSharedMemory

# 从我们重构的模块中导入主窗口
from gui.main_window import BotGUI

def setup_logging():
    """配置全局日志记录器。"""
    logging.basicConfig(
        level=logging.INFO,
        format='%(asctime)s - %(levelname)s - %(message)s',
        handlers=[
            logging.StreamHandler()                               # 输出到控制台
        ]
    )

if __name__ == "__main__":
    # 1. 配置日志
    setup_logging()

    # 2. 创建Qt应用实例
    app = QApplication(sys.argv)

    # 3. 防止程序多开
    unique_key = "BinanceAlphaBot_f8d4h3g49d8j_unique_instance_lock"
    shared_memory = QSharedMemory(unique_key)
    if not shared_memory.create(1):
        QMessageBox.warning(None, "启动错误", "程序已经在运行中，请勿重复打开。")
        sys.exit(0)
    # 将共享内存附加到app对象，防止其被垃圾回收
    app.shared_memory = shared_memory

    # 4. 创建并显示主窗口
    gui = BotGUI()
    # 启动授权检查，如果成功则显示窗口
    # 注意: check_activation_and_run 方法现在是 BotGUI 的一部分
    gui.check_activation_and_run()

    # 5. 启动Qt事件循环
    sys.exit(app.exec())